library(DESeq2)
library(ggplot2)
args=commandArgs(T)
file <- args[1]
file1 <- args[2]
count.data <- read.csv(file,header = T)
exp.data <- count.data[,-1*1:6]
rownames(exp.data) <- count.data[,1]
colnames(exp.data) <- gsub(".R1.new.sam", "", colnames(exp.data))
mycounts <- exp.data
condition<- factor(c(rep("control1",2),rep("control2",2),rep("treat1",2),rep("tr
colData <- data.frame(names = c("control-6h-1","control-6h-2","control-12h-1","c
rownames(colData) = colnames(mycounts)
dds <- DESeqDataSetFromMatrix(mycounts,colData ,design = ~condition)
keep <- rowSums(counts(dds))>=8
dds <- dds[keep,]
dds_norm <- DESeq(dds)
rld <- rlog(dds)
plotPCA(rld,intgroup=c("condition","names"))
pcaData <- plotPCA(rld,intgroup=c("condition","names"),returnData=T)
percentVar <- round(100*attr(pcaData,"percentVar"))
pca <- ggplot(pcaData,aes(PC1,PC2,color=names,shape=condition))+geom_point(size=3)+ggtitle("DESeq2 PCA")+xlab(paste0("PC1:",percentVar[1],"% variance"))+ylab(paste0("PC2:", percentVar[2],"% variance"))+theme_bw()
pdf(file1,width=8,height=8)
pca
dev.off()
